/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.nosql.mongo.dsl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.streamscape.Trace;
import com.streamscape.omf.xsd.JsonParser;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class MongoJsonParser
extends JsonParser {
    protected JsonNode onBeforeParse(String key, JsonNode value, String path, Map<String, String> typesMap) {
        JsonNode result = value;
        if (value.isObject() && value.size() == 1) {
            if (key.equals("_id")) {
                JsonNode oid = value.get("$oid");
                if (oid != null && oid.isTextual()) {
                    return oid;
                }
            } else {
                JsonNode member = value.get("$date");
                if (member != null) {
                    result = member;
                    if (!typesMap.containsKey(path)) {
                        typesMap.put(path, "date");
                        try {
                            String s = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(member.asLong()));
                            result = new TextNode(s);
                        }
                        catch (Exception exception) {
                            Trace.logError((Object)((Object)this), (String)"Failed to get $date as long.");
                        }
                    }
                } else {
                    member = value.get("$timestamp");
                    if (member != null) {
                        if (member.isObject() && member.has("t")) {
                            result = member.get("t");
                            if (!typesMap.containsKey(path)) {
                                typesMap.put(path, "SqlTimestamp");
                                try {
                                    String s = new Timestamp(result.asLong()).toString();
                                    result = new TextNode(s);
                                }
                                catch (Exception exception) {
                                    Trace.logError((Object)((Object)this), (String)"Failed to get $timestamp as long.");
                                }
                            }
                        } else {
                            result = member;
                        }
                    } else {
                        member = value.get("$numberLong");
                        if (member != null) {
                            result = member;
                            if (!typesMap.containsKey(path)) {
                                typesMap.put(path, "long");
                                result = new LongNode(member.asLong());
                            }
                        }
                    }
                }
            }
        } else if (value.isObject() && value.size() == 2) {
            JsonNode member = null;
            member = value.get("$binary");
            if (member != null && value.get("$type") != null) {
                result = member;
                if (!typesMap.containsKey(path)) {
                    typesMap.put(path, "byte[]");
                    try {
                        result = new TextNode(member.asText());
                    }
                    catch (Exception exception) {
                        Trace.logError((Object)((Object)this), (String)"Failed to get $date as long.");
                    }
                }
            }
        }
        return result;
    }
}

