/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.nosql.mongo.client;

import com.streamscape.lib.nosql.mongo.client.MongoClientConnection;
import com.streamscape.lib.nosql.mongo.dsl.MongoFactoryConnectionLexiconProcessor;
import com.streamscape.lib.nosql.mongo.dsl.parser.external.MongoExternalParser;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sef.dispatcher.AbstractFactoryConnectionService;
import com.streamscape.sef.factory.connection.external.ExternalParser;
import com.streamscape.slex.DSLComponent;
import com.streamscape.slex.SemanticLexiconProcessor;

public class MongoFactoryConnectionService
extends AbstractFactoryConnectionService {
    private MongoClientConnection connection;
    private MongoFactoryConnectionLexiconProcessor lexiconProcessor;

    MongoFactoryConnectionService(MongoClientConnection connection) {
        this.connection = connection;
    }

    protected void onInit() throws Exception {
        this.connection.connect();
    }

    public void destroy() {
        try {
            this.connection.disconnect();
        }
        catch (ClientException exception) {
            this.logError("Disconnect failed. Cause: " + exception.getMessage());
        }
    }

    public SemanticLexiconProcessor getLexiconProcessor() {
        if (this.lexiconProcessor == null) {
            this.lexiconProcessor = new MongoFactoryConnectionLexiconProcessor(RuntimeContext.getInstance(), (DSLComponent<MongoFactoryConnectionService>)this.getDSLComponent((Object)this));
        }
        return this.lexiconProcessor;
    }

    public MongoClientConnection getConnection() {
        return this.connection;
    }

    public ExternalParser getExternalParser() {
        return new MongoExternalParser(this);
    }
}

